<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>

<title><?php page_title(); ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=<?php if(defined('DEFAULT_CHARSET')) { echo DEFAULT_CHARSET; } else { echo 'utf-8'; }?>" />
<meta name="description" content="<?php page_description(); ?>" />
<meta name="keywords" content="<?php page_keywords(); ?>" />
         
    <link rel="stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/bluesky.css" media="screen, tv, projection" title="Default" />
    <link rel="alternative stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/bluesky_large.css" media="screen, projection, tv" title="Larger Fonts" />
    
    <link rel="alternative stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/print.css" media="screen" title="Print Preview" />
    <link rel="alternative stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/handheld.css" media="screen" title="Small Layout Preview" />
    
    <link rel="stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/handheld.css" media="handheld" title="Small Layout" />
    <link rel="stylesheet" type="text/css" href="<?php echo TEMPLATE_DIR; ?>/print.css" media="print" />

        
</head>
<body>

<div id="page">
    
    <div id="header">
        <a href=""><?php page_title('', '[WEBSITE_TITLE]'); ?></a>
    </div>
    
    <div id="wrapper"> 
        
        <div id="content">
        
            <div id="path">
            <?php
            function new_breadcrumbs($sep=' > ',$tier=1,$links=true,$depth=-1) {
   global $wb;
   $page_id=$wb->page_id;
   if ($page_id!=0)
   {
       global $database;
      $bca=$wb->page_trail;
      $counter=0;
      foreach ($bca as $temp)
      {
           if ($counter>=($tier-1) AND ($depth<0 OR $tier+$depth>$counter))
           {
            if ($counter>=$tier) echo $sep;
            $query_menu=$database->query("SELECT menu_title,link FROM ".TABLE_PREFIX."pages WHERE page_id=$temp");
            $page=$query_menu->fetchRow();
            if ($links==true AND $temp!=$page_id)
               echo '<a href="'.page_link($page['link']).'">'.$page['menu_title'].'</a>';
            else
                echo $page['menu_title'];
           }
            $counter++;
      }
   }
}
            ?>
                You are here: <?php new_breadcrumbs(' &raquo; ',1,true);?> 
                
            </div>
    
            <div id="main">

                <h1><?php page_title('','[PAGE_TITLE]'); ?></h1>
    
                <p>
                    <?php page_content(); ?>
                </p>
    
            </div>

        </div>
        
        <div id="left">

            <div id="nav">
            
                <h3>Menu</h3>

                <div class="inner_box">

                    <ul>
                        <?php show_menu(); ?>
                    </ul>                
                </div>
                
                <!-- i love clean source code -->
                
            </div>

            
            <?php ob_start();     // start output buffer
page_content(2);   // call menu
$foo=ob_get_contents();    // put outputbuffer in $foo
ob_end_clean();             // clear outputbuffer
if ($foo<>"") {  // some code to execute cause there is some block
  echo '<div class="left_box">';
  echo '<h3>Latest news</h3>';
  echo '<div class="inner_box">';
  echo '<p>';
  echo $foo; // show the block (as saved in $foo)
  echo '</p>';
  echo '</div>';
  echo '</div>';
  
    } else { // some code for no info
}
?>	
                     
        </div>

    </div>
    
    <div id="footer">
        <p>Powered by <a href="http://www.websitebaker.org/" target="_blank">
			Website Baker</a>&nbsp; -&nbsp;&copy;&nbsp;<?php page_title('','[WEBSITE_TITLE]'); ?>&nbsp; -&nbsp;
		    Webdesign by <a href="http://www.jonasjohn.de/" target="_blank">Jonas John</a>. 
            
            <!-- please leave a small credit to the author - thanks :-) ! -->
            
        </p>
    </div>

</div>

</body>
</html>